package com.izenpe.zain.cliente.pdf;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import org.apache.axis.encoding.Base64;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.VerifyResponse;

import com.izenpe.zain.cliente.util.Constantes;
import com.izenpe.zain.cliente.util.Propiedades;
import com.izenpe.zain.cliente.util.ZainUtil;
import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartVerifyRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartVerifyResponse;
import com.safelayer.www.TWS.SignatureResultType;
import com.safelayer.www.TWS.TimeStampValues;

public class VerificacionFirmaPDFSerie {	
	//Nombre del fichero a utilizar para la Verificacin de la firma PDF.
	private static final String signName = "PruebaPDF-SignedSerie.pdf";
	
	public static void main(String[] args) {
		try {
			/*
			 * Se crea la peticin a travs de la URL definida en ZAIN_ENDPOINT.
			 */
			SmartVerifyRequest smartVerifyReq = new SmartVerifyRequest(Propiedades.ZAIN_ENDPOINT);
				
			//Se establece el perfil PDF en la peticin de Verificacin de firma.
			smartVerifyReq.setProfile(Constants.Profile.PDF);			

			//Se solicita que se aadan los valores del Sello de Tiempo a la respuesta.
			smartVerifyReq.setAddTimeStampValues(Constants.AddValues.SIMPLE);
			
			/*
			 * Se establece el idioma de la peticin en espaol. 2 posibilidades:
			 * 	 1. Espaol: 'es'
			 * 	 2. Ingls:  'en'
			 */
			smartVerifyReq.setLanguage("es");
			
			//Datos a verificar.
			smartVerifyReq.setInputPdfBase64Data(Base64.encode(ZainUtil.readBinaryFile("data/output/" + signName)));
			
			//Envo de la peticin.
			SmartVerifyResponse smartVerifyResp = smartVerifyReq.send();
			
			//Se comprueba la validez de la respuesta de Verificacin de firma PDF.
			//Obtener de la respuesta la hora obtenida de la TSA.
			if (Constantes.RMAJOR_SUCCESS.equals((smartVerifyResp.getResultMajor())) && "urn:oasis:names:tc:dss:1.0:resultminor:ValidSignature_RevisionsInSomeDocuments".equals(smartVerifyResp.getResultMinor())) {
				System.out.println("La firma ha sido verificada con xito.");
				VerifyResponse verifyResponseAxis = (VerifyResponse)smartVerifyResp.getInternalObject();
				SignatureResultType[] signatureResultTypes = verifyResponseAxis.getOptionalOutputs().getMultiSignatureResult().getSignatureResult();
				for(int i=0;i<signatureResultTypes.length;i++){
					TimeStampValues timeStampValues= signatureResultTypes[i].getOptionalOutputs().getTimeStampValues();
					if (timeStampValues != null) {
						Calendar creationTime = timeStampValues.getTimeStampValue()[0].getTstInfo().getCreationTime();
						DateFormat df = SimpleDateFormat.getDateTimeInstance();
						System.out.println("Hora obtenida de la TSA para la firma "+(i+1)+": " + df.format(creationTime.getTime()));
					}
				}
				
			}
			else {
				System.out.println("La firma tiene errores: " + smartVerifyResp.getResultMessage());
			}
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
}